<?php
//	
//	Habbo standalone avatar image generator
//	version 0.8.5 beta / Aug.1 2013
//	
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//	
//	Copyright 2013 T-Racing Development / coded by Tsuka
//	
//	http://www.t-racing.org
//	

define("LITE_RECOLOR_FUNCTION", false);
// Use function fast processing at color subtraction.
// processing speed improves, but there is little difference from the real color.

$settings[res_path]		= "./res_cct_human/";

$settings[json_path]	= "./json/";
$settings[memberalias]	= json_decode(file_get_contents($settings[json_path]."memberalias.json"), true);
$settings[figuredata]	= json_decode(file_get_contents($settings[json_path]."figuredata.json"), true);
$settings[draworder]	= json_decode(file_get_contents($settings[json_path]."draworder.json"), true);
$settings[animation]	= json_decode(file_get_contents($settings[json_path]."animation.json"), true);
$settings[partsets]		= json_decode(file_get_contents($settings[json_path]."partsets.json"), true);
$settings[reglist]		= json_decode(file_get_contents($settings[json_path]."reglist.json"), true);

class AvatarImage
{
	var $figure					= array();
	var $direction				= 0;
	var $headDirection			= 0;
	var $action					= array("std");
	var $gesture				= "std";
	var $frame					= array(0);
	var $isSmall				= false;
	var $isHeadOnly				= false;
	var $rectWidth				= 64;
	var $rectHeight				= 110;
	
	var $handItem				= false;
	var $drawAction				= array(
									"body"		=> "std",
									"walk"		=> false,
									"sit"		=> false,
									"gesture"	=> false,
									"eye"		=> false,
									"speak"		=> false,
									"itemRight"	=> false,
									"handRight"	=> false,
									"handLeft"	=> false,
									"swim"		=> false
								);
	
	var $drawOrder				= "std";
	
	function AvatarImage($figure, $direction, $headDirection, $action, $gesture, $frame, $isHeadOnly, $isSmall)
	{
		$parts = explode('.', $figure);
		if(count($parts) == 0)
		{
			exit;
		}
		foreach($parts as $value){
			$data = explode("-", $value);
			array_push($this->figure, array("type"=>$data[0], "id"=>$data[1], "color"=>$data[2]));
		}
		if($isSmall)
		{
			$this->isSmall = true;
			$this->rectWidth = 32;
			$this->rectHeight = 55;
		}
		if($isHeadOnly)
		{
			$this->isHeadOnly = true;
			$this->rectHeight = (int)($this->rectHeight / 2);
		}
		$this->direction = $this->validateDirection($direction) ? $direction : 0;
		$this->headDirection = $this->validateDirection($headDirection) ? $headDirection : 0;
		
		$this->gesture = $gesture;
		switch($this->gesture)
		{
			case "spk":
				$this->drawAction[speak]	= $this->gesture;
				break;
			case "eyb":
				$this->drawAction[eye]		= $this->gesture;
				break;
			case "":
				$this->drawAction[gesture]	= "std";
				break;
			default:
				$this->drawAction[gesture]	= $this->gesture;
				break;
		}
		$this->action = is_array($action) ? $action : array($action);
		foreach($this->action as $value){
			$_action = explode("=", $value);
			switch($_action[0])
			{
				case "wlk":
					$this->drawAction[walk]			= "wlk";
					break;
				case "sit":
					$this->drawAction[sit]			= $_action[0];
					break;
				case "lay":
					$this->drawAction[body]			= $_action[0];
					$this->drawAction[eye]			= $_action[0];
					list($this->rectWidth, $this->rectHeight) = array($this->rectHeight, $this->rectWidth);
					switch($this->gesture)
					{
						case "spk":
							$this->drawAction[speak]	= "lsp";
							break;
						case "eyb":
							$this->drawAction[eye]		= "ley";
							break;
						case "std":
							$this->drawAction[gesture]	= $_action[0];
							break;
						default:
							$this->drawAction[gesture]	= "l".substr($this->gesture, 0, 2);
							break;
					}
					break;
				case "wav":
					$this->drawAction[handLeft]		= $_action[0];
					break;
				case "crr":
				case "drk":
					$this->drawAction[handRight]	= $_action[0];
					$this->drawAction[itemRight]	= $_action[0];
					$this->handItem					= (int)$_action[1];
					break;
				case "swm":
					$this->drawAction[swm]			= $_action[0];
					if($this->gesture == "spk")
					{
						$this->drawAction[speak]	= "sws";
					}
					break;
				case "":
					$this->drawAction[body]			= "std";
					break;
				default:
					$this->drawAction[body]			= $_action[0];
					break;
			}
		}
		if($this->drawAction[sit] == "sit")
		{
			if($this->direction >= 2 && $this->direction <= 4)
			{
				$this->drawOrder = "sit";
				if($this->drawAction[handRight] == "drk"  && $this->direction >= 2 && $this->direction <= 3)
				{
					$this->drawOrder .= ".rh-up";
				}
				elseif($this->drawAction[handLeft] && $this->direction == 4)
				{
					$this->drawOrder .= ".lh-up";
				}
			}
		}
		elseif($this->drawAction[body] == "lay")
		{
			$this->drawOrder = "lay";
		}
		elseif($this->drawAction[handRight] == "drk"  && $this->direction >= 0 && $this->direction <= 3)
		{
			$this->drawOrder = "rh-up";
		}
		elseif($this->drawAction[handLeft] && $this->direction >= 4 && $this->direction <= 6)
		{
			$this->drawOrder = "lh-up";
		}
		$frame = is_array($frame) ? $frame : array($frame);
		foreach($frame as $value){
			$_frame = explode("=", $value);
			$_action = $_frame[0] != "" ? $_frame[0] : "def";
			$this->frame[$_action] = (int)$_frame[1];
		}
		return true;
	}
	
	function HEX2RGB($hex)
	{
		$rgb = array();
		for ($x=0;$x<3;$x++){
			$rgb[$x] = hexdec(substr($hex,(2*$x),2));
		}
		return $rgb;
	}
	function getKeyByValue($target, $search)
	{
		foreach($target as $key => $value)
		{
			if($value == $search) return $key;
		}
		return -1;
	}
	function getKeyByAttr($target, $attr, $search)
	{
		foreach($target as $key => $value)
		{
			if($target[$key]["@attributes"][$attr] == $search) return $key;
		}
		return -1;
	}
	function getAttr($target, $attr)
	{
		$value = $target["@attributes"][$attr];
		return $value != "" ? $value : false;
	}
	function validateDirection($direction)
	{
		return (is_numeric($direction) && $direction >= 0 && $direction <= 7);
	}
	
	function Generate($format = "png")
	{
		$avatarImage = imageCreateTrueColor($this->rectWidth, $this->rectHeight);
		imageAlphaBlending($avatarImage, false);
		imageSaveAlpha($avatarImage, true);
		$rectMask = imageColorAllocateAlpha($avatarImage, 255, 0, 255, 127);
		imageFill($avatarImage, 0, 0, $rectMask);
		
		$activeParts[rect]		= $this->getActivePartSet($this->isHeadOnly ? "head" : "figure", true);
		$activeParts[head]		= $this->getActivePartSet("head");
		$activeParts[eye]		= $this->getActivePartSet("eye");
		$activeParts[gesture]	= $this->getActivePartSet("gesture");
		$activeParts[speak]		= $this->getActivePartSet("speak");
		$activeParts[walk]		= $this->getActivePartSet("walk");
		$activeParts[sit]		= $this->getActivePartSet("sit");
		$activeParts[itemRight]	= $this->getActivePartSet("itemRight");
		$activeParts[handRight]	= $this->getActivePartSet("handRight");
		$activeParts[handLeft]	= $this->getActivePartSet("handLeft");
		$activeParts[swim]		= $this->getActivePartSet("swim");
		
		$drawParts = $this->getDrawOrder($this->drawOrder, $this->direction);
		if($drawParts === false)
		{
			$drawParts = $this->getDrawOrder("std", $this->direction);
		}
		
		$setParts = array();
		foreach($this->figure as $partSet){
			$setParts = array_merge($setParts, $this->getPartColor($partSet[type], $partSet[id], $partSet[color]));
		}
		if($this->handItem !== false)
		{
			$setParts["ri"] = array("id" => $this->handItem);
		}
		
		imageAlphaBlending($avatarImage, true);
		
		foreach($drawParts as $id => $type)
		{
			$drawPart		= $setParts[$type];
			
			if($setParts[hidden][$type])
			{
				continue;
			}
			if(!is_array($drawPart))
			{
				continue;
			}
			if($this->isHeadOnly && !$activeParts[rect][$type][active])
			{
				continue;
			}
			
			$drawDirection		= $this->direction;
			$drawAction			= false;
			if($activeParts[rect][$type][active])
			{
				$drawAction		= $this->drawAction[body];
			}
			if($activeParts[head][$type][active])
			{
				$drawDirection	= $this->headDirection;
			}
			if($activeParts[speak][$type][active] && $this->drawAction[speak])
			{
				$drawAction		= $this->drawAction[speak];
			}
			if($activeParts[gesture][$type][active] && $this->drawAction[gesture])
			{
				$drawAction		= $this->drawAction[gesture];
			}
			if($activeParts[eye][$type][active])
			{
				$drawPart[colorble] = false;
				if($this->drawAction[eye])
				{
					$drawAction	= $this->drawAction[eye];
				}
			}
			if($activeParts[walk][$type][active] && $this->drawAction[walk])
			{
				$drawAction		= $this->drawAction[walk];
			}
			if($activeParts[sit][$type][active] && $this->drawAction[sit])
			{
				$drawAction		= $this->drawAction[sit];
			}
			if($activeParts[handRight][$type][active] && $this->drawAction[handRight])
			{
				$drawAction		= $this->drawAction[handRight];
			}
			if($activeParts[itemRight][$type][active] && $this->drawAction[itemRight])
			{
				$drawAction		= $this->drawAction[itemRight];
			}
			if($activeParts[handLeft][$type][active] && $this->drawAction[handLeft])
			{
				$drawAction		= $this->drawAction[handLeft];
			}
			if($activeParts[swim][$type][active] && $this->drawAction[swim])
			{
				$drawAction		= $this->drawAction[swim];
			}
			
			if(!$drawAction)
			{
				continue;
			}
			$drawPartRes = $this->getPartResourceName($drawAction, $type, $drawPart[id], $drawDirection);
			$drawPartRect = $this->getPartResource($drawPartRes);
			if($drawPartRect === false)
			{
				continue;
			}
			
			$drawPartRectTransparentColor = imageColorTransparent($drawPartRect[resource]);
			if($drawPart[colorble])
			{
				$this->setPartColor($drawPartRect[resource], $drawPart[color]);
			}
			
			$_posX = -$drawPartRect[offset][locH];
			$_posY = ($this->rectHeight / 2) - $drawPartRect[offset][locV] + ($this->isHeadOnly ? $this->rectHeight * 1.2 : $this->rectHeight / 2.5);
			if($drawPartRect[isFlip]) $_posX = -($_posX + $drawPartRect[width] - ($this->rectWidth + 1));
			imageCopy($avatarImage, $drawPartRect[resource], $_posX, $_posY, 0, 0, $drawPartRect[width], $drawPartRect[height]);
			
			imageDestroy($drawPartRect[resource]);
		}
		
		ob_start();
		if($format == "gif")
		{
			imageGIF($avatarImage);
		}
		elseif($format == "png")
		{
			imagePNG($avatarImage);
		}
		else
		{
			ob_end_clean();
			exit;
		}
		$resource = ob_get_contents();
		ob_end_clean();
		imageDestroy($avatarImage);
		return $resource;
	}
	function setPartColor(&$resource, $color)
	{
		$replaceColor = $this->HEX2RGB($color);
		if(LITE_RECOLOR_FUNCTION)
		{
			imageFilter($resource, IMG_FILTER_COLORIZE, $replaceColor[0]-255, $replaceColor[1]-255, $replaceColor[2]-255);
		}
		else
		{
			$width		= imageSX($resource);
			$height		= imageSY($resource);
			$tpColor	= imageColorAllocateAlpha($resource, 255, 0, 255, 127);
			for($y = 0; $y < $height; $y++)
			{
				for($x = 0; $x < $width; $x++)
				{
					$rgb = imageColorAt($resource, $x, $y);
					if($rgb != $tpColor)
					{
						$rgb = imageColorsForIndex($resource, $rgb);
						$nr = max(round($rgb[red]	* $replaceColor[0] / 255), 0);
						$ng = max(round($rgb[green]	* $replaceColor[1] / 255), 0);
						$nb = max(round($rgb[blue]	* $replaceColor[2] / 255), 0);
						imageSetPixel($resource, $x, $y, imageColorAllocate($resource, $nr, $ng, $nb));
					}
				}
			}
		}
		return true;
	}
	function getColorByPaletteID($paletteID, $colorID)
	{
		global $settings;
		$partColor = $settings[figuredata][colors][palette];
		$partColor = $partColor[$this->getKeyByAttr($partColor, "id", $paletteID)];
		$partColor = $partColor[color][$this->getKeyByAttr($partColor[color], "id", $colorID)]["do"];
		return $partColor;
	}
	function getPartColor($type, $partID, $colorID)
	{
		global $settings;
		$partsSetType = $settings[figuredata][sets][settype];
		$partsSetType = $partsSetType[$this->getKeyByAttr($partsSetType, "type", $type)];
		$partsPaletteID = $this->getAttr($partsSetType, "paletteid");
		$partsSet = $partsSetType[set][$this->getKeyByAttr($partsSetType[set], "id", $partID)];
		$data = array();
		foreach($partsSet[part] as $part){
			$partColor = $this->getColorByPaletteID($partsPaletteID, $colorID);
			if(count($part["@attributes"]) > 0) $part = $part["@attributes"];
			$data[$part[type]] = array(
				"id"		=> $part[id],
				"colorble"	=> ($part[colorable] == "1"),
				"color"		=> $partColor
			);
		}
		if(count($partsSet[hiddenlayers]) > 0)
		{
			foreach($partsSet[hiddenlayers][layer] as $part){
				$data[hidden][$part[parttype]] = true;
			}
		}
		return $data;
	}
	function getActivePartSet($partSet, $addAttr = false)
	{
		global $settings;
		$activeParts = $settings[partsets][activePartSet];
		$activeParts = $activeParts[$this->getKeyByAttr($activeParts, "id", $partSet)];
		if(count($activeParts) == 0) return false;
		$partSetData = $settings[partsets][partSet][part];
		$data = array();
		foreach($activeParts[activePart] as $id => $part){
			$setType = ($id === "@attributes") ? $part["set-type"] : $this->getAttr($part, "set-type");
			$data[$setType][active] = true;
			if($addAttr)
			{
				$partData = $partSetData[$this->getKeyByAttr($partSetData, "set-type", $setType)];
				$data[$setType][remove] = $this->getAttr($partData, "remove-set-type");
				$data[$setType][flip] = $this->getAttr($partData, "flipped-set-type");
				$data[$setType][swim] = $this->getAttr($partData, "swim");
			}
		}
		return $data;
	}
	function getDrawOrder($action, $direction)
	{
		global $settings;
		$drawOrder = $settings[draworder][action];
		$drawOrder = $drawOrder[$this->getKeyByAttr($drawOrder, "id", $action)];
		$drawOrder = $drawOrder[direction][$this->getKeyByAttr($drawOrder[direction], "id", $direction)];
		$data = array();
		if(count($drawOrder[partList][part]) == 0) return false;
		foreach($drawOrder[partList][part] as $id => $part)
		{
			$data[$id] = $this->getAttr($part, "set-type");
		}
		return $data;
	}
	function getFrameNumber($type, $action, $frame)
	{
		global $settings;
		$frameSet = $settings[animation][action];
		$frameSet = $frameSet[$this->getKeyByAttr($frameSet, "id", $action)];
		if(count($frameSet) == 0) return 0;
		$frameSet = $frameSet[part][$this->getKeyByAttr($frameSet[part], "set-type", $type)];
		if(count($frameSet) == 0) return 0;
		$data = $this->getAttr($frameSet[frame][$frame], "number");
		return $data !== false ? $data : 0;
	}
	function getPartResourceName($action, $type, $partId, $direction)
	{
		$resourceName = $this->isSmall ? "sh" : "h";
		$resourceName .= "_";
		$resourceName .= $action;
		$resourceName .= "_";
		$resourceName .= $type;
		$resourceName .= "_";
		$resourceName .= $partId;
		$resourceName .= "_";
		$resourceName .= $direction;
		$resourceName .= "_";
		$resourceName .= $this->getFrameNumber($type, $action, (int)$this->frame[$action]);
		return $resourceName;
	}
	function getPartResourcePosition($name)
	{
		global $settings;
		$regList = $settings[reglist][member];
		$regList = $regList[$this->getKeyByAttr($regList, "name", $name)];
		return $regList[0]["@attributes"];
	}
	function getPartResource($name)
	{
		global $settings;
		$filename = $settings[res_path];
		if($settings[memberalias][$name] != "")
		{
			$aliasname = $settings[memberalias][$name];
			if(substr($aliasname, -1, 1) == "*")
			{
				$filename .= substr($aliasname, 0, -1);
				$isFlip = true;
			}
		}
		else
		{
			$filename .= $name;
		}
		$filename .= ".png";
		if(!file_exists($filename))
		{
			$_direction = substr($filename, -7, 1);
			if($_direction > 3 && $_direction < 7)
			{
				$filename = basename($filename, ".png");
				$_type = substr($filename, 6, 2);
				$partData = $settings[partsets][partSet][part];
				$partData = $partData[$this->getKeyByAttr($partData, "set-type", $_type)];
				$flippedPart = $this->getAttr($partData, "flipped-set-type");
				if($flippedPart !== false)
				{
					$filename = substr_replace($filename, $flippedPart, 6, 2);
				}
				$filename = $settings[res_path].$filename.".png";
				
				if(!file_exists($filename))
				{
					$isFlip = true;
					$_direction = 6 - $_direction;
					$filename = substr_replace($filename, $_direction, -7, 1);
				}
				if(!file_exists($filename)) return false;
			}
			else return false;
		}
		
		$resource = imageCreateFromPNG($filename);
		imageAlphaBlending($resource, false);
		$rectMask = imageColorAllocateAlpha($resource, 255, 0, 255, 127);
		imageFill($resource, 0, 0, $rectMask);
		imageSaveAlpha($resource, true);
		
		$this->setResample($resource, $isFlip);
		
		$data = array(
			"resource"	=> $resource,
			"name"		=> basename($filename, ".png"),
			"filename"	=> $filename,
			"isFlip"	=> $isFlip,
			"width"		=> imageSX($resource),
			"height"	=> imageSY($resource),
			"offset"	=> $this->getPartResourcePosition(basename($filename, ".png"))
		);
		
		return $data;
	}
	function setResample(&$resource, $isFlip)
	{
		$width	= imagesx($resource);
		$height	= imagesy($resource);
		$temp = imageCreateTrueColor($width, $height);
		imageAlphaBlending($temp, false);
		$rectMask = imageColorAllocateAlpha($temp, 255, 0, 255, 127);
		imageFill($temp, 0, 0, $rectMask);
		imageSaveAlpha($temp, true);
		$x = imageCopyResampled($temp, $resource, 0, 0, ($isFlip?($width-1):0), 0, $width, $height, ($isFlip?(0-$width):$width), $height);
		if($x) {
			$resource = $temp;
		}
		return true;
	}
}

$inputFigure		= strtolower($_GET["figure"]);
$inputAction		= strtolower($_GET["action"]);
$inputDirection		= (int)$_GET["direction"];
$inputHeadDirection	= (int)$_GET["head_direction"];
$inputGesture		= strtolower($_GET["gesture"]);
$inputSize			= strtolower($_GET["size"]);
$inputFormat		= strtolower($_GET["img_format"]);
$inputFrame			= strtolower($_GET["frame"]);
$inputHeadOnly		= strtolower($_GET["head_only"]);

$inputAction		= explode(",", $inputAction);
$inputSize			= $inputSize == "s" ? true : false;
$inputFormat		= $inputFormat == "gif" ? "gif" : "png";
$inputFrame			= explode(",", $inputFrame);
$inputHeadOnly		= $inputHeadOnly == "true" ? true : false;

$avatarImage = new AvatarImage($inputFigure, $inputDirection, $inputHeadDirection, $inputAction, $inputGesture, $inputFrame, $inputHeadOnly, $inputSize);
$image = $avatarImage->Generate();

if($image !== false)
{
	header('Content-Type: image/'.$inputFormat);
	echo $image;
}

?>